/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.BackReference;
import org.jetbrains.exposed.dao.ColumnWithTransform;
import org.jetbrains.exposed.dao.DaoEntityID;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityCacheKt;
import org.jetbrains.exposed.dao.ImmutableEntityClass;
import org.jetbrains.exposed.dao.OptionalBackReference;
import org.jetbrains.exposed.dao.OptionalReference;
import org.jetbrains.exposed.dao.OptionalReferrers;
import org.jetbrains.exposed.dao.Reference;
import org.jetbrains.exposed.dao.Referrers;
import org.jetbrains.exposed.dao.View;
import org.jetbrains.exposed.dao.exceptions.EntityNotFoundException;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Count;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IterableExKt;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryAlias;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SizedCollection;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u0001*\u0010\b\u0001\u0010\u0004 \u0001*\b\u0012\u0004\u0012\u00028\u00000\u00032\u00020\u0005B,\u0012\r\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000b\u0012\u0012\b\u0002\u0010\u00a2\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0093\u0001\u00a2\u0006\u0006\b\u00a3\u0001\u0010\u00a4\u0001J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0013\u001a\u00028\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0017\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0004\b\u0015\u0010\u001aJ\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001eJK\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\u0017\u00a2\u0006\u0002\b\u00192\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0017\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0004\b!\u0010\"J)\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0#H\u0016\u00a2\u0006\u0004\b%\u0010&J!\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#\u00a2\u0006\u0004\b'\u0010&J\u0018\u0010(\u001a\u00028\u00012\u0006\u0010\u001b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b(\u0010\u001dJ\u001e\u0010(\u001a\u00028\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0086\u0002\u00a2\u0006\u0004\b(\u0010\u001eJ\u001d\u0010-\u001a\u00020*2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0010\u00a2\u0006\u0004\b+\u0010,JA\u0010/\u001a\u00020\n\"\u000e\b\u0002\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00020\u00032\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000\u00a2\u0006\u0004\b/\u00100J2\u00102\u001a\u00028\u00012\b\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020*0\u0017\u00a2\u0006\u0002\b\u0019H\u0016\u00a2\u0006\u0004\b2\u00103J(\u00102\u001a\u00028\u00012\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020*0\u0017\u00a2\u0006\u0002\b\u0019H\u0016\u00a2\u0006\u0004\b2\u00104JB\u00109\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000108\"\u000e\b\u0002\u00105*\b\u0012\u0004\u0012\u00028\u00020\u00012\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000206H\u0086\u0004\u00a2\u0006\u0004\b9\u0010:J@\u0010<\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010;\"\u000e\b\u0002\u00105*\b\u0012\u0004\u0012\u00028\u00020\u00012\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000206H\u0086\u0004\u00a2\u0006\u0004\b<\u0010=J6\u0010A\u001a\u00028\u0002\"\n\b\u0002\u0010>\u0018\u0001*\u00020\u00052\n\u00107\u001a\u0006\u0012\u0002\b\u0003062\f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00020?H\u0082\b\u00a2\u0006\u0004\bA\u0010BJ'\u0010E\u001a\u0004\u0018\u00018\u00012\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\b\b\u0002\u0010D\u001a\u00020\n\u00a2\u0006\u0004\bE\u0010FJ\u001b\u0010G\u001a\u00020*2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\bG\u0010,J\u001d\u0010I\u001a\u00020H2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\bI\u0010JJ,\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\u0017\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0004\bK\u0010LJ\u001d\u0010K\u001a\u0004\u0018\u00018\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0004\bK\u0010\u001eJ8\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010M2\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0017\u00a2\u0006\u0002\b\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\bN\u0010OJ\u000f\u0010Q\u001a\u00020PH\u0014\u00a2\u0006\u0004\bQ\u0010RJ9\u0010W\u001a\b\u0012\u0004\u0012\u00028\u00010#2\u0010\u0010S\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0#2\u0006\u0010U\u001a\u00020T2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\bW\u0010XJC\u0010[\u001a\b\u0012\u0004\u0012\u00028\u00010#\"\u0004\b\u0002\u0010Y2\f\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00020#2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u0002062\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b[\u0010\\JA\u0010]\u001a\b\u0012\u0004\u0012\u00028\u00010#\"\u0004\b\u0002\u0010Y2\f\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00020#2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u0002062\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b]\u0010\\J%\u0010^\u001a\u00028\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b^\u0010\u0014J\u0015\u0010_\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b_\u0010`J'\u0010_\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00020\u00112\u0010\u0010c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0a\u00a2\u0006\u0004\b_\u0010dJ\u001d\u0010_\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010c\u001a\u00020e\u00a2\u0006\u0004\b_\u0010fJ!\u0010h\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\u0004\bh\u0010iJ3\u0010h\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0010\u0010c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0a\u00a2\u0006\u0004\bh\u0010jJ)\u0010h\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010c\u001a\u00020e\u00a2\u0006\u0004\bh\u0010kJp\u0010o\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u00030n\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000406H\u0086\u0004\u00a2\u0006\u0004\bo\u0010pJr\u0010o\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u00030n\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000406H\u0087\u0004\u00a2\u0006\u0004\bq\u0010pJ\u0082\u0001\u0010s\u001a&\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u00040r\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000406H\u0086\u0004\u00a2\u0006\u0004\bs\u0010tJ\u0084\u0001\u0010s\u001a&\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u00040r\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000406H\u0087\u0004\u00a2\u0006\u0004\bu\u0010tJ\u0084\u0001\u0010w\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040v\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000406H\u0086\u0004\u00a2\u0006\u0004\bw\u0010xJ\u008b\u0001\u0010w\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040v\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u0004062\b\b\u0002\u0010y\u001a\u00020\n\u00a2\u0006\u0004\bw\u0010zJ\u0082\u0001\u0010|\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040{\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000406H\u0086\u0004\u00a2\u0006\u0004\b|\u0010}J\u0087\u0001\u0010|\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040{\"\u000e\b\u0002\u0010l*\b\u0012\u0004\u0012\u00028\u00020\u0001\"\u000e\b\u0003\u0010m*\b\u0012\u0004\u0012\u00028\u00020\u0003\"\u000e\b\u0004\u00105*\b\u0012\u0004\u0012\u00028\u00040\u0001*\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u0004062\u0006\u0010y\u001a\u00020\n\u00a2\u0006\u0004\b|\u0010~J\u0014\u0010\u007f\u001a\u00020H*\u00020HH\u0002\u00a2\u0006\u0005\b\u007f\u0010\u0080\u0001J_\u0010\u0086\u0001\u001a\u000f\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0085\u0001\"\u0005\b\u0002\u0010\u0081\u0001\"\u0005\b\u0003\u0010\u0082\u0001*\b\u0012\u0004\u0012\u00028\u0002062\u0013\u0010\u0083\u0001\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00020\u00172\u0013\u0010\u0084\u0001\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0017\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001R'\u0010\u008a\u0001\u001a\u0012\u0012\r\u0012\u000b \u0089\u0001*\u0004\u0018\u00010\u00050\u00050\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008a\u0001\u0010\u008b\u0001R'\u0010\u008e\u0001\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0005060#8VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0018\u0010\u0092\u0001\u001a\u00030\u008f\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R$\u0010\u0094\u0001\u001a\u0007\u0012\u0002\b\u00030\u0093\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u0094\u0001\u0010\u0095\u0001\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001Ra\u0010\u009c\u0001\u001aL\u0012\u001a\u0012\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u000306\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u009a\u00010\u0099\u0001\u0012\u0004\u0012\u00020\u00050\u0098\u0001j%\u0012\u001a\u0012\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u000306\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u009a\u00010\u0099\u0001\u0012\u0004\u0012\u00020\u0005`\u009b\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u009d\u0001R\"\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000b8\u0006\u00a2\u0006\u0010\n\u0006\b\u009e\u0001\u0010\u009f\u0001\u001a\u0006\b\u00a0\u0001\u0010\u00a1\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00a5\u0001"}, d2={"Lorg/jetbrains/exposed/dao/EntityClass;", "", "ID", "Lorg/jetbrains/exposed/dao/Entity;", "T", "", "Lorg/jetbrains/exposed/sql/SizedIterable;", "all", "()Lorg/jetbrains/exposed/sql/SizedIterable;", "Lorg/jetbrains/exposed/sql/Op;", "", "op", "", "count", "(Lorg/jetbrains/exposed/sql/Op;)J", "Lorg/jetbrains/exposed/dao/id/EntityID;", "entityId", "Lorg/jetbrains/exposed/sql/ResultRow;", "row", "createInstance", "(Lorg/jetbrains/exposed/dao/id/EntityID;Lorg/jetbrains/exposed/sql/ResultRow;)Lorg/jetbrains/exposed/dao/Entity;", "find", "(Lorg/jetbrains/exposed/sql/Op;)Lorg/jetbrains/exposed/sql/SizedIterable;", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/SizedIterable;", "id", "findById", "(Ljava/lang/Comparable;)Lorg/jetbrains/exposed/dao/Entity;", "(Lorg/jetbrains/exposed/dao/id/EntityID;)Lorg/jetbrains/exposed/dao/Entity;", "cacheCheckCondition", "Lkotlin/sequences/Sequence;", "findWithCacheCondition", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lkotlin/sequences/Sequence;", "", "ids", "forEntityIds", "(Ljava/util/List;)Lorg/jetbrains/exposed/sql/SizedIterable;", "forIds", "get", "o", "", "invalidateEntityInCache$exposed_dao", "(Lorg/jetbrains/exposed/dao/Entity;)V", "invalidateEntityInCache", "entityClass", "isAssignableTo", "(Lorg/jetbrains/exposed/dao/EntityClass;)Z", "init", "new", "(Ljava/lang/Comparable;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/Entity;", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/Entity;", "REF", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/dao/OptionalReference;", "optionalReferencedOn", "(Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/dao/OptionalReference;", "Lorg/jetbrains/exposed/dao/Reference;", "referencedOn", "(Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/dao/Reference;", "R", "Lkotlin/Function0;", "ref", "registerRefRule", "(Lorg/jetbrains/exposed/sql/Column;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "entity", "flush", "reload", "(Lorg/jetbrains/exposed/dao/Entity;Z)Lorg/jetbrains/exposed/dao/Entity;", "removeFromCache", "Lorg/jetbrains/exposed/sql/Query;", "searchQuery", "(Lorg/jetbrains/exposed/sql/Op;)Lorg/jetbrains/exposed/sql/Query;", "testCache", "(Lkotlin/jvm/functions/Function1;)Lkotlin/sequences/Sequence;", "Lorg/jetbrains/exposed/dao/View;", "view", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/View;", "Lorg/jetbrains/exposed/dao/EntityCache;", "warmCache", "()Lorg/jetbrains/exposed/dao/EntityCache;", "references", "Lorg/jetbrains/exposed/sql/Table;", "linkTable", "forUpdate", "warmUpLinkedReferences", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/Table;Ljava/lang/Boolean;)Ljava/util/List;", "SID", "refColumn", "warmUpOptReferences", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Boolean;)Ljava/util/List;", "warmUpReferences", "wrap", "wrapRow", "(Lorg/jetbrains/exposed/sql/ResultRow;)Lorg/jetbrains/exposed/dao/Entity;", "Lorg/jetbrains/exposed/sql/Alias;", "Lorg/jetbrains/exposed/dao/id/IdTable;", "alias", "(Lorg/jetbrains/exposed/sql/ResultRow;Lorg/jetbrains/exposed/sql/Alias;)Lorg/jetbrains/exposed/dao/Entity;", "Lorg/jetbrains/exposed/sql/QueryAlias;", "(Lorg/jetbrains/exposed/sql/ResultRow;Lorg/jetbrains/exposed/sql/QueryAlias;)Lorg/jetbrains/exposed/dao/Entity;", "rows", "wrapRows", "(Lorg/jetbrains/exposed/sql/SizedIterable;)Lorg/jetbrains/exposed/sql/SizedIterable;", "(Lorg/jetbrains/exposed/sql/SizedIterable;Lorg/jetbrains/exposed/sql/Alias;)Lorg/jetbrains/exposed/sql/SizedIterable;", "(Lorg/jetbrains/exposed/sql/SizedIterable;Lorg/jetbrains/exposed/sql/QueryAlias;)Lorg/jetbrains/exposed/sql/SizedIterable;", "TargetID", "Target", "Lkotlin/properties/ReadOnlyProperty;", "backReferencedOn", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;)Lkotlin/properties/ReadOnlyProperty;", "backReferencedOnOpt", "Lorg/jetbrains/exposed/dao/OptionalBackReference;", "optionalBackReferencedOn", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/dao/OptionalBackReference;", "optionalBackReferencedOnOpt", "Lorg/jetbrains/exposed/dao/OptionalReferrers;", "optionalReferrersOn", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/dao/OptionalReferrers;", "cache", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;Z)Lorg/jetbrains/exposed/dao/OptionalReferrers;", "Lorg/jetbrains/exposed/dao/Referrers;", "referrersOn", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/dao/Referrers;", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/sql/Column;Z)Lorg/jetbrains/exposed/dao/Referrers;", "setForUpdateStatus", "(Lorg/jetbrains/exposed/sql/Query;)Lorg/jetbrains/exposed/sql/Query;", "TColumn", "TReal", "toColumn", "toReal", "Lorg/jetbrains/exposed/dao/ColumnWithTransform;", "transform", "(Lorg/jetbrains/exposed/sql/Column;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/dao/ColumnWithTransform;", "Lkotlin/reflect/KFunction;", "kotlin.jvm.PlatformType", "ctor", "Lkotlin/reflect/KFunction;", "getDependsOnColumns", "()Ljava/util/List;", "dependsOnColumns", "Lorg/jetbrains/exposed/sql/ColumnSet;", "getDependsOnTables", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "dependsOnTables", "Ljava/lang/Class;", "klass", "Ljava/lang/Class;", "getKlass$exposed_dao", "()Ljava/lang/Class;", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lkotlin/collections/HashMap;", "refDefinitions", "Ljava/util/HashMap;", "table", "Lorg/jetbrains/exposed/dao/id/IdTable;", "getTable", "()Lorg/jetbrains/exposed/dao/id/IdTable;", "entityType", "<init>", "(Lorg/jetbrains/exposed/dao/id/IdTable;Ljava/lang/Class;)V", "exposed-dao"})
public abstract class EntityClass<ID extends Comparable<? super ID>, T extends Entity<ID>> {
    @NotNull
    private final IdTable<ID> table;
    @NotNull
    private final Class<?> klass;
    @NotNull
    private final KFunction<Object> ctor;
    @NotNull
    private final HashMap<Pair<Column<?>, KClass<?>>, Object> refDefinitions;

    public EntityClass(@NotNull IdTable<ID> table, @Nullable Class<T> entityType) {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        this.table = table;
        Class<Object> clazz = entityType;
        if (clazz == null && (clazz = this.getClass().getEnclosingClass()) == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<T of org.jetbrains.exposed.dao.EntityClass>");
        }
        this.klass = clazz;
        KFunction kFunction = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(this.klass));
        Intrinsics.checkNotNull((Object)kFunction);
        this.ctor = kFunction;
        this.refDefinitions = new HashMap();
    }

    public /* synthetic */ EntityClass(IdTable idTable, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clazz = null;
        }
        this(idTable, clazz);
    }

    @NotNull
    public final IdTable<ID> getTable() {
        return this.table;
    }

    @NotNull
    public final Class<?> getKlass$exposed_dao() {
        return this.klass;
    }

    @NotNull
    public final T get(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        T t = this.findById(id2);
        if (t == null) {
            throw new EntityNotFoundException(id2, this);
        }
        return t;
    }

    @NotNull
    public final T get(@NotNull ID id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        return this.get((ID)new DaoEntityID<ID>(id2, this.table));
    }

    @NotNull
    protected EntityCache warmCache() {
        return EntityCacheKt.getEntityCache(TransactionManager.Companion.current());
    }

    @Nullable
    public final T findById(@NotNull ID id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        return this.findById((EntityID)new DaoEntityID<ID>(id2, this.table));
    }

    @Nullable
    public T findById(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Object object = this.testCache(id2);
        if (object == null) {
            object = (Entity)CollectionsKt.firstOrNull((Iterable)this.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(this, id2){
                final /* synthetic */ EntityClass<ID, T> this$0;
                final /* synthetic */ EntityID<ID> $id;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                    Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                    return $this$find.eq((ExpressionWithColumnType)this.this$0.getTable().getId(), this.$id);
                }
            })));
        }
        return object;
    }

    @Nullable
    public final T reload(@NotNull Entity<ID> entity, boolean flush2) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (flush2) {
            if (entity.isNewEntity$exposed_dao()) {
                EntityCacheKt.getEntityCache(TransactionManager.Companion.current()).flushInserts$exposed_dao(this.table);
            } else {
                Entity.flush$default(entity, null, 1, null);
            }
        }
        this.removeFromCache(entity);
        return entity.getId().get_value() != null ? (T)this.findById(entity.getId()) : null;
    }

    public static /* synthetic */ Entity reload$default(EntityClass entityClass, Entity entity, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reload");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return entityClass.reload(entity, bl);
    }

    public void invalidateEntityInCache$exposed_dao(@NotNull Entity<ID> o) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        boolean entityAlreadyFlushed = o.getId().get_value() != null;
        boolean sameDatabase = Intrinsics.areEqual((Object)TransactionManager.Companion.current().getDb(), (Object)o.getDb());
        if (entityAlreadyFlushed && sameDatabase) {
            T currentEntityInCache = this.testCache(o.getId());
            if (currentEntityInCache == null) {
                this.get((ID)o.getId());
                this.warmCache().store(o);
            } else if (currentEntityInCache != o) {
                SQLLogKt.getExposedLogger().error("Entity instance in cache differs from the provided: " + Reflection.getOrCreateKotlinClass(o.getClass()).getSimpleName() + " with ID " + o.getId().getValue() + ". Changes on entity could be missed.");
            }
        }
    }

    @Nullable
    public final T testCache(@NotNull EntityID<ID> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        return this.warmCache().find(this, id2);
    }

    @NotNull
    public final Sequence<T> testCache(@NotNull Function1<? super T, Boolean> cacheCheckCondition) {
        Intrinsics.checkNotNullParameter(cacheCheckCondition, (String)"cacheCheckCondition");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.warmCache().findAll(this)), (Function1)new Function1<T, Boolean>(cacheCheckCondition){
            final /* synthetic */ Function1<T, Boolean> $cacheCheckCondition;
            {
                this.$cacheCheckCondition = $cacheCheckCondition;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Boolean)this.$cacheCheckCondition.invoke(it);
            }
        });
    }

    public final void removeFromCache(@NotNull Entity<ID> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        EntityCache cache = this.warmCache();
        cache.remove(this.table, entity);
        Map $this$forEach$iv = cache.getReferrers$exposed_dao();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it;
            Map.Entry element$iv;
            Map.Entry $dstr$col$referrers = element$iv = iterator2.next();
            boolean bl = false;
            Column col = (Column)$dstr$col$referrers.getKey();
            Map referrers = (Map)$dstr$col$referrers.getValue();
            referrers.remove(entity.getId());
            if (!Intrinsics.areEqual((Object)col.getTable(), this.getTable())) continue;
            Entity<ID> $this$removeFromCache_u24lambda_u2d2_u24lambda_u2d0 = entity;
            boolean bl2 = false;
            if ($this$removeFromCache_u24lambda_u2d2_u24lambda_u2d0.lookup(col) == null) continue;
            boolean bl3 = false;
            SizedIterable cfr_ignored_0 = (SizedIterable)referrers.remove((EntityID)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SizedIterable<T> forEntityIds(@NotNull List<? extends EntityID<ID>> ids2) {
        void $this$forEntityIds_u24lambda_u2d4;
        SqlExpressionBuilder $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        List distinctIds = CollectionsKt.distinct((Iterable)ids2);
        if (distinctIds.isEmpty()) {
            return IterableExKt.emptySized();
        }
        Iterable $this$mapNotNull$iv = distinctIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            T it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EntityID it = (EntityID)element$iv$iv;
            boolean bl2 = false;
            if (this.testCache(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cached = (List)destination$iv$iv;
        if (cached.size() == distinctIds.size()) {
            return new SizedCollection(cached);
        }
        Op.Companion this_$iv = Op.Companion;
        boolean $i$f$build = false;
        $this$mapNotNullTo$iv$iv = SqlExpressionBuilder.INSTANCE;
        EntityClass entityClass = this;
        EntityClass entityClass2 = this;
        boolean bl = false;
        Op op = $this$forEntityIds_u24lambda_u2d4.inList(this.getTable().getId(), distinctIds);
        return entityClass2.wrapRows(entityClass.searchQuery(op));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SizedIterable<T> forIds(@NotNull List<? extends ID> ids2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        Iterable iterable = ids2;
        EntityClass entityClass = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Comparable comparable = (Comparable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DaoEntityID<void>(it, this.getTable()));
        }
        return entityClass.forEntityIds((List)destination$iv$iv);
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        return IterableExKt.mapLazy(rows, (Function1)new Function1<ResultRow, T>(this){
            final /* synthetic */ EntityClass<ID, T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.wrapRow(it);
            }
        });
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows, @NotNull Alias<? extends IdTable<?>> alias) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(alias, (String)"alias");
        return IterableExKt.mapLazy(rows, (Function1)new Function1<ResultRow, T>(this, alias){
            final /* synthetic */ EntityClass<ID, T> this$0;
            final /* synthetic */ Alias<IdTable<?>> $alias;
            {
                this.this$0 = $receiver;
                this.$alias = $alias;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.wrapRow(it, this.$alias);
            }
        });
    }

    @NotNull
    public final SizedIterable<T> wrapRows(@NotNull SizedIterable<ResultRow> rows, @NotNull QueryAlias alias) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return IterableExKt.mapLazy(rows, (Function1)new Function1<ResultRow, T>(this, alias){
            final /* synthetic */ EntityClass<ID, T> this$0;
            final /* synthetic */ QueryAlias $alias;
            {
                this.this$0 = $receiver;
                this.$alias = $alias;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull ResultRow it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.wrapRow(it, this.$alias);
            }
        });
    }

    @NotNull
    public final T wrapRow(@NotNull ResultRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        T entity = this.wrap((EntityID)row.get(this.table.getId()), row);
        if (((Entity)entity).get_readValues() == null) {
            ((Entity)entity).set_readValues(row);
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T wrapRow(@NotNull ResultRow row, @NotNull Alias<? extends IdTable<?>> alias) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter(alias, (String)"alias");
        if (!Intrinsics.areEqual(alias.getDelegate(), this.table)) {
            boolean $i$a$-require-EntityClass$wrapRow$22 = false;
            String $i$a$-require-EntityClass$wrapRow$22 = "Alias for a wrong table " + alias.getDelegate().getTableName() + " while " + this.getTable().getTableName() + " expected";
            throw new IllegalArgumentException($i$a$-require-EntityClass$wrapRow$22.toString());
        }
        Map<Expression<?>, Integer> $this$mapNotNull$iv = row.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        Map<Expression<?>, Integer> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Column column;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$exp$_u24__u24 = element$iv$iv;
            boolean bl2 = false;
            Expression exp = (Expression)$dstr$exp$_u24__u24.getKey();
            Column column2 = exp instanceof Column ? (Column)exp : null;
            Object value2 = row.get(exp);
            if (column2 == null) {
                column = null;
            } else {
                Column it;
                boolean bl3 = false;
                column = alias.originalColumn(it);
            }
            Column originalColumn = column;
            if (originalColumn != null) {
                object = TuplesKt.to(originalColumn, value2);
            } else {
                Column column3 = column2;
                object = Intrinsics.areEqual((Object)(column3 == null ? null : column3.getTable()), alias.getDelegate()) ? null : TuplesKt.to((Object)exp, value2);
            }
            if (object == null) continue;
            Pair it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map newFieldsMapping = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return this.wrapRow(ResultRow.Companion.createAndFillValues(newFieldsMapping));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T wrapRow(@NotNull ResultRow row, @NotNull QueryAlias alias) {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            Iterable $this$any$iv = alias.getColumns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((Alias)((Column)it).getTable()).getDelegate(), this.getTable())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean $i$a$-require-EntityClass$wrapRow$42 = false;
            String $i$a$-require-EntityClass$wrapRow$42 = "QueryAlias doesn't have any column from " + this.getTable().getTableName() + " table";
            throw new IllegalArgumentException($i$a$-require-EntityClass$wrapRow$42.toString());
        }
        List<Column<?>> originalColumns = alias.getQuery().getSet().getSource().getColumns();
        Map<Expression<?>, Integer> $this$mapNotNull$iv = row.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry $dstr$exp$_u24__u24 = element$iv$iv;
            boolean bl4 = false;
            Expression exp = (Expression)$dstr$exp$_u24__u24.getKey();
            Object value2 = row.get(exp);
            if (exp instanceof Column && ((Column)exp).getTable() instanceof Alias) {
                Object delegate = ((Alias)((Column)exp).getTable()).getDelegate();
                Iterable $this$single$iv = originalColumns;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    Column it2 = (Column)element$iv;
                    boolean bl5 = false;
                    if (!(Intrinsics.areEqual(delegate, (Object)it2.getTable()) && Intrinsics.areEqual((Object)((Column)exp).getName(), (Object)it2.getName()))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Column column = single$iv;
                object = TuplesKt.to((Object)column, value2);
            } else {
                object = exp instanceof Column && Intrinsics.areEqual((Object)((Column)exp).getTable(), this.getTable()) ? null : TuplesKt.to((Object)exp, value2);
            }
            if (object == null) continue;
            Pair it$iv$iv = object;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map newFieldsMapping = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return this.wrapRow(ResultRow.Companion.createAndFillValues(newFieldsMapping));
    }

    @NotNull
    public SizedIterable<T> all() {
        return this.wrapRows(QueriesKt.selectAll(this.table).notForUpdate());
    }

    @NotNull
    public final SizedIterable<T> find(@NotNull Op<Boolean> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        this.warmCache();
        return this.wrapRows(this.searchQuery(op));
    }

    @NotNull
    public final SizedIterable<T> find(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        return this.find((Op)op.invoke((Object)SqlExpressionBuilder.INSTANCE));
    }

    @NotNull
    public final Sequence<T> findWithCacheCondition(@NotNull Function1<? super T, Boolean> cacheCheckCondition, @NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(cacheCheckCondition, (String)"cacheCheckCondition");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Sequence cached = this.testCache(cacheCheckCondition);
        return SequencesKt.any(cached) ? cached : CollectionsKt.asSequence((Iterable)this.find(op));
    }

    @NotNull
    public ColumnSet getDependsOnTables() {
        return this.table;
    }

    @NotNull
    public List<Column<? extends Object>> getDependsOnColumns() {
        return this.getDependsOnTables().getColumns();
    }

    @NotNull
    public Query searchQuery(@NotNull Op<Boolean> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        FieldSet $this$select$iv = this.getDependsOnTables().slice(this.getDependsOnColumns());
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        EntityClass entityClass = this;
        boolean bl = false;
        Op<Boolean> op2 = op;
        return entityClass.setForUpdateStatus(QueriesKt.select(fieldSet, op2));
    }

    public final long count(@Nullable Op<Boolean> op) {
        Count countExpression = SQLExpressionBuilderKt.count((ExpressionWithColumnType)this.table.getId());
        Query query2 = QueriesKt.selectAll(this.table.slice(countExpression, new Expression[0])).notForUpdate();
        Op<Boolean> op2 = op;
        if (op2 != null) {
            Op<Boolean> it = op2;
            boolean bl = false;
            query2.adjustWhere((Function1<? super Op<Boolean>, ? extends Op<Boolean>>)((Function1)new Function1<Op<Boolean>, Op<Boolean>>(op){
                final /* synthetic */ Op<Boolean> $op;
                {
                    this.$op = $op;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@Nullable Op<Boolean> $this$adjustWhere) {
                    return this.$op;
                }
            }));
        }
        return ((Number)((ResultRow)CollectionsKt.first((Iterable)query2)).get(countExpression)).longValue();
    }

    public static /* synthetic */ long count$default(EntityClass entityClass, Op op, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n & 1) != 0) {
            op = null;
        }
        return entityClass.count(op);
    }

    @NotNull
    protected T createInstance(@NotNull EntityID<ID> entityId2, @Nullable ResultRow row) {
        Intrinsics.checkNotNullParameter(entityId2, (String)"entityId");
        Object[] objectArray = new Object[]{entityId2};
        Object object = this.ctor.call(objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of org.jetbrains.exposed.dao.EntityClass");
        }
        return (T)((Entity)object);
    }

    @NotNull
    public final T wrap(@NotNull EntityID<ID> id2, @Nullable ResultRow row) {
        Object t;
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Transaction transaction2 = TransactionManager.Companion.current();
        Object t2 = EntityCacheKt.getEntityCache(transaction2).find(this, id2);
        if (t2 == null) {
            T t3;
            T t4 = t3 = this.createInstance(id2, row);
            boolean bl = false;
            ((Entity)t4).setKlass$exposed_dao(this);
            ((Entity)t4).setDb$exposed_dao(transaction2.getDb());
            this.warmCache().store(this, t4);
            t = t3;
        } else {
            t = t2;
        }
        return t;
    }

    @NotNull
    public T new(@NotNull Function1<? super T, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        return this.new(null, init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public T new(@Nullable ID id2, @NotNull Function1<? super T, Unit> init) {
        EntityID entityID;
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (id2 == null && this.table.getId().getDefaultValueFun() != null) {
            Function0<EntityID<ID>> function0 = this.table.getId().getDefaultValueFun();
            Intrinsics.checkNotNull(function0);
            entityID = (EntityID)function0.invoke();
        } else {
            entityID = new DaoEntityID<ID>(id2, this.table);
        }
        EntityID entityId2 = entityID;
        EntityCache entityCache2 = this.warmCache();
        T prototype = this.createInstance(entityId2, null);
        ((Entity)prototype).setKlass$exposed_dao(this);
        ((Entity)prototype).setDb$exposed_dao(TransactionManager.Companion.current().getDb());
        ((Entity)prototype).set_readValues(ResultRow.Companion.createAndFillDefaults(this.getDependsOnColumns()));
        if (entityId2.get_value() != null) {
            Map map2 = ((Entity)prototype).getWriteValues();
            Column<EntityID<ID>> column = this.table.getId();
            map2.put(column, entityId2);
        }
        try {
            entityCache2.addNotInitializedEntityToQueue$exposed_dao((Entity<?>)prototype);
            init.invoke(prototype);
        }
        finally {
            entityCache2.finishEntityInitialization$exposed_dao((Entity<?>)prototype);
        }
        if (entityId2.get_value() == null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            ResultRow resultRow = ((Entity)prototype).get_readValues();
            Intrinsics.checkNotNull((Object)resultRow);
            ResultRow readValues = resultRow;
            LinkedHashMap<Column<Object>, Object> writeValues = ((Entity)prototype).getWriteValues();
            Iterable $this$filter$iv = this.table.getColumns();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Column col = (Column)element$iv$iv;
                boolean bl = false;
                if (!(col.getDefaultValueFun() != null && !((Map)writeValues).containsKey(col) && readValues.hasValue(col))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Column col = (Column)element$iv;
                boolean bl = false;
                ((Map)writeValues).put(col, readValues.get(col));
            }
        }
        entityCache2.scheduleInsert(this, prototype);
        return prototype;
    }

    @NotNull
    public final View<T> view(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        boolean $i$f$view = false;
        return new View((Op)op.invoke((Object)SqlExpressionBuilder.INSTANCE), this);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <R> R registerRefRule(Column<?> column, Function0<? extends R> ref) {
        Object object;
        void $this$getOrPut$iv;
        boolean $i$f$registerRefRule = false;
        Map map2 = this.refDefinitions;
        Intrinsics.reifiedOperationMarker((int)4, (String)"R");
        Pair key$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(Object.class));
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object answer$iv = ref.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"R");
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <REF extends Comparable<? super REF>> Reference<REF, ID, T> referencedOn(@NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass this_$iv = this;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(Reference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Reference answer$iv$iv = new Reference(column, this);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Reference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <REF extends Comparable<? super REF>> OptionalReference<REF, ID, T> optionalReferencedOn(@NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass this_$iv = this;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(OptionalReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReference answer$iv$iv = new OptionalReference(column, this);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> ReadOnlyProperty<Entity<ID>, Target> backReferencedOn(@NotNull EntityClass<TargetID, ? extends Target> $this$backReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$backReferencedOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$backReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(BackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            BackReference answer$iv$iv = new BackReference(column, $this$backReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (BackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="backReferencedOnOpt")
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> ReadOnlyProperty<Entity<ID>, Target> backReferencedOnOpt(@NotNull EntityClass<TargetID, ? extends Target> $this$backReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$backReferencedOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$backReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(BackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            BackReference answer$iv$iv = new BackReference(column, $this$backReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (BackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalBackReference<TargetID, Target, ID, Entity<ID>, REF> optionalBackReferencedOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalBackReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalBackReferencedOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalBackReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(OptionalBackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalBackReference answer$iv$iv = new OptionalBackReference(column, $this$optionalBackReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalBackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="optionalBackReferencedOnOpt")
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalBackReference<TargetID, Target, ID, Entity<ID>, REF> optionalBackReferencedOnOpt(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalBackReferencedOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalBackReferencedOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalBackReferencedOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(OptionalBackReference.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalBackReference answer$iv$iv = new OptionalBackReference(column, $this$optionalBackReferencedOn);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalBackReference)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> Referrers<ID, Entity<ID>, TargetID, Target, REF> referrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$referrersOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$referrersOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$referrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(Referrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Referrers answer$iv$iv = new Referrers(column, $this$referrersOn, true);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Referrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> Referrers<ID, Entity<ID>, TargetID, Target, REF> referrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$referrersOn, @NotNull Column<REF> column, boolean cache) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$referrersOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$referrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(Referrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            Referrers answer$iv$iv = new Referrers(column, $this$referrersOn, cache);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (Referrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalReferrers<ID, Entity<ID>, TargetID, Target, REF> optionalReferrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalReferrersOn, @NotNull Column<REF> column) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalReferrersOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalReferrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(OptionalReferrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReferrers answer$iv$iv = new OptionalReferrers(column, $this$optionalReferrersOn, true);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReferrers)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetID extends Comparable<? super TargetID>, Target extends Entity<TargetID>, REF extends Comparable<? super REF>> OptionalReferrers<ID, Entity<ID>, TargetID, Target, REF> optionalReferrersOn(@NotNull EntityClass<TargetID, ? extends Target> $this$optionalReferrersOn, @NotNull Column<REF> column, boolean cache) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter($this$optionalReferrersOn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        EntityClass<TargetID, ? extends Target> this_$iv = $this$optionalReferrersOn;
        boolean $i$f$registerRefRule = false;
        Map map2 = this_$iv.refDefinitions;
        Pair key$iv$iv = TuplesKt.to(column, (Object)Reflection.getOrCreateKotlinClass(OptionalReferrers.class));
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            OptionalReferrers answer$iv$iv = new OptionalReferrers(column, $this$optionalReferrersOn, cache);
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        return (OptionalReferrers)object;
    }

    public static /* synthetic */ OptionalReferrers optionalReferrersOn$default(EntityClass entityClass, EntityClass entityClass2, Column column, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: optionalReferrersOn");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return entityClass.optionalReferrersOn(entityClass2, column, bl);
    }

    @NotNull
    public final <TColumn, TReal> ColumnWithTransform<TColumn, TReal> transform(@NotNull Column<TColumn> $this$transform, @NotNull Function1<? super TReal, ? extends TColumn> toColumn, @NotNull Function1<? super TColumn, ? extends TReal> toReal) {
        Intrinsics.checkNotNullParameter($this$transform, (String)"<this>");
        Intrinsics.checkNotNullParameter(toColumn, (String)"toColumn");
        Intrinsics.checkNotNullParameter(toReal, (String)"toReal");
        return new ColumnWithTransform<TColumn, TReal>($this$transform, toColumn, toReal);
    }

    private final Query setForUpdateStatus(Query $this$setForUpdateStatus) {
        return this instanceof ImmutableEntityClass ? $this$setForUpdateStatus.notForUpdate() : $this$setForUpdateStatus;
    }

    @NotNull
    public final <SID> List<T> warmUpOptReferences(@NotNull List<? extends SID> references2, @NotNull Column<SID> refColumn, @Nullable Boolean forUpdate) {
        Intrinsics.checkNotNullParameter(references2, (String)"references");
        Intrinsics.checkNotNullParameter(refColumn, (String)"refColumn");
        return this.warmUpReferences(references2, refColumn, forUpdate);
    }

    public static /* synthetic */ List warmUpOptReferences$default(EntityClass entityClass, List list2, Column column, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpOptReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpOptReferences(list2, column, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <SID> List<T> warmUpReferences(@NotNull List<? extends SID> references2, @NotNull Column<SID> refColumn, @Nullable Boolean forUpdate) {
        void $this$forEach$iv;
        void $this$warmUpReferences_u24lambda_u2d34;
        Intrinsics.checkNotNullParameter(references2, (String)"references");
        Intrinsics.checkNotNullParameter(refColumn, (String)"refColumn");
        Column<?> column = refColumn.getReferee();
        Table table = column == null ? null : column.getTable();
        IdTable parentTable = table instanceof IdTable ? (IdTable)table : null;
        if (parentTable == null) {
            boolean $i$a$-requireNotNull-EntityClass$warmUpReferences$22 = false;
            String $i$a$-requireNotNull-EntityClass$warmUpReferences$22 = "RefColumn should have reference to IdTable";
            throw new IllegalArgumentException($i$a$-requireNotNull-EntityClass$warmUpReferences$22.toString());
        }
        if (references2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List distinctRefIds = CollectionsKt.distinct((Iterable)references2);
        Transaction transaction2 = TransactionManager.Companion.current();
        EntityCache cache = EntityCacheKt.getEntityCache(transaction2);
        boolean keepLoadedReferenceOutOfTransaction = transaction2.getDb().getConfig().getKeepLoadedReferencesOutOfTransaction();
        if (refColumn.getColumnType() instanceof EntityIDColumnType) {
            void $this$flatMapTo$iv$iv;
            Object result2;
            Iterator $this$groupByTo$iv$iv;
            Object element$iv$iv;
            Boolean $this$filterTo$iv$iv;
            Iterable $this$filter$iv = distinctRefIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object object = $this$filterTo$iv$iv.iterator();
            while (object.hasNext()) {
                boolean bl;
                boolean bl2;
                Object it = element$iv$iv = object.next();
                boolean bl3 = false;
                Map<EntityID<?>, SizedIterable<?>> map2 = cache.getReferrers$exposed_dao().get(refColumn);
                if (!(map2 == null ? true : (bl2 = !(bl = map2.containsKey(it))))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toLoad = (List)destination$iv$iv;
            if (!((Collection)toLoad).isEmpty()) {
                Object element$iv$iv2;
                SizedIterable<T> findQuery2 = this.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(refColumn, (List<? extends Object>)toLoad){
                    final /* synthetic */ Column<SID> $refColumn;
                    final /* synthetic */ List<Object> $toLoad;
                    {
                        this.$refColumn = $refColumn;
                        this.$toLoad = $toLoad;
                        super(1);
                    }

                    @NotNull
                    public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                        return $this$find.inList(this.$refColumn, (Iterable)this.$toLoad);
                    }
                }));
                $this$filterTo$iv$iv = forUpdate;
                List entities = CollectionsKt.toList((Iterable)(Intrinsics.areEqual((Object)$this$filterTo$iv$iv, (Object)true) ? findQuery2.forUpdate() : (Intrinsics.areEqual((Object)$this$filterTo$iv$iv, (Object)false) ? findQuery2.notForUpdate() : findQuery2)));
                Iterable $this$groupBy$iv = entities;
                boolean $i$f$groupBy = false;
                object = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator bl3 = $this$groupByTo$iv$iv.iterator();
                while (bl3.hasNext()) {
                    Object object2;
                    element$iv$iv2 = bl3.next();
                    Entity it = (Entity)element$iv$iv2;
                    boolean bl = false;
                    EntityID key$iv$iv = (EntityID)it.getReadValues().get(refColumn);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv2);
                }
                result2 = destination$iv$iv2;
                Iterable $this$forEach$iv2 = distinctRefIds;
                boolean $i$f$forEach = false;
                $this$groupByTo$iv$iv = $this$forEach$iv2.iterator();
                while ($this$groupByTo$iv$iv.hasNext()) {
                    Object element$iv;
                    Object id2 = element$iv = $this$groupByTo$iv$iv.next();
                    boolean bl = false;
                    Object it = element$iv$iv2 = cache.getOrPutReferrers((EntityID)id2, refColumn, (Function0)new Function0<SizedIterable<? extends T>>(result2, id2){
                        final /* synthetic */ Map<EntityID<?>, List<T>> $result;
                        final /* synthetic */ Object $id;
                        {
                            this.$result = $result;
                            this.$id = $id;
                            super(0);
                        }

                        @NotNull
                        public final SizedIterable<T> invoke() {
                            SizedCollection<T> sizedCollection;
                            List<T> list2 = this.$result.get(this.$id);
                            if (list2 == null) {
                                sizedCollection = null;
                            } else {
                                List<T> it = list2;
                                boolean bl = false;
                                sizedCollection = new SizedCollection<T>((Collection)it);
                            }
                            return sizedCollection == null ? IterableExKt.emptySized() : (SizedIterable<T>)sizedCollection;
                        }
                    });
                    boolean bl5 = false;
                    if (!keepLoadedReferenceOutOfTransaction) continue;
                    T t = this.findById((EntityID)id2);
                    if (t == null) continue;
                    ((Entity)t).storeReferenceInCache$exposed_dao(refColumn, it);
                }
            }
            Iterable $this$flatMap$iv = distinctRefIds;
            boolean $i$f$flatMap = false;
            result2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            $this$groupByTo$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$groupByTo$iv$iv.hasNext()) {
                Object it = element$iv$iv = $this$groupByTo$iv$iv.next();
                boolean bl = false;
                SizedIterable sizedIterable = cache.getReferrers((EntityID)it, refColumn);
                List list2 = sizedIterable == null ? null : CollectionsKt.toList((Iterable)sizedIterable);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Op.Companion this_$iv = Op.Companion;
        boolean $i$f$build = false;
        SqlExpressionBuilder $this$flatMapTo$iv$iv = SqlExpressionBuilder.INSTANCE;
        EntityClass entityClass = this;
        boolean $i$a$-build-EntityClass$warmUpReferences$baseQuery$22 = false;
        Query baseQuery = entityClass.searchQuery($this$warmUpReferences_u24lambda_u2d34.inList(refColumn, distinctRefIds));
        Query finalQuery2 = baseQuery.getSet().getFields().contains(parentTable.getId()) ? baseQuery : baseQuery.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)((Function2)new Function2<ColumnSet, FieldSet, FieldSet>(parentTable){
            final /* synthetic */ IdTable<?> $parentTable;
            {
                this.$parentTable = $parentTable;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                Intrinsics.checkNotNullParameter((Object)$this$adjustSlice, (String)"$this$adjustSlice");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $this$adjustSlice.slice(CollectionsKt.plus((Collection)$this$adjustSlice.getFields(), this.$parentTable.getId()));
            }
        })).adjustColumnSet((Function1<? super ColumnSet, ? extends ColumnSet>)((Function1)new Function1<ColumnSet, ColumnSet>(parentTable, refColumn){
            final /* synthetic */ IdTable<?> $parentTable;
            final /* synthetic */ Column<SID> $refColumn;
            {
                this.$parentTable = $parentTable;
                this.$refColumn = $refColumn;
                super(1);
            }

            @NotNull
            public final ColumnSet invoke(@NotNull ColumnSet $this$adjustColumnSet) {
                Intrinsics.checkNotNullParameter((Object)$this$adjustColumnSet, (String)"$this$adjustColumnSet");
                return TableKt.innerJoin$default($this$adjustColumnSet, this.$parentTable, (Function1)new Function1<ColumnSet, Expression<?>>(this.$refColumn){
                    final /* synthetic */ Column<SID> $refColumn;
                    {
                        this.$refColumn = $refColumn;
                        super(1);
                    }

                    @NotNull
                    public final Expression<?> invoke(@NotNull ColumnSet $this$innerJoin) {
                        Intrinsics.checkNotNullParameter((Object)$this$innerJoin, (String)"$this$innerJoin");
                        return this.$refColumn;
                    }
                }, (Function1)new Function1<IdTable<?>, Expression<?>>(this.$refColumn){
                    final /* synthetic */ Column<SID> $refColumn;
                    {
                        this.$refColumn = $refColumn;
                        super(1);
                    }

                    @NotNull
                    public final Expression<?> invoke(@NotNull IdTable<?> $this$innerJoin) {
                        Intrinsics.checkNotNullParameter($this$innerJoin, (String)"$this$innerJoin");
                        Column<?> column = this.$refColumn.getReferee();
                        Intrinsics.checkNotNull(column);
                        return column;
                    }
                }, null, 8, null);
            }
        }));
        SizedIterable<T> findQuery3 = this.wrapRows(finalQuery2);
        Boolean $i$a$-build-EntityClass$warmUpReferences$baseQuery$22 = forUpdate;
        List entities = CollectionsKt.distinct((Iterable)CollectionsKt.toList((Iterable)(Intrinsics.areEqual((Object)$i$a$-build-EntityClass$warmUpReferences$baseQuery$22, (Object)true) ? findQuery3.forUpdate() : (Intrinsics.areEqual((Object)$i$a$-build-EntityClass$warmUpReferences$baseQuery$22, (Object)false) ? findQuery3.notForUpdate() : findQuery3))));
        Object $this$groupBy$iv = entities;
        boolean $i$f$groupBy = false;
        Iterable $this$groupByTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            EntityID key$iv$iv = (EntityID)it.getReadValues().get(parentTable.getId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            SizedIterable sizedIterable;
            Map.Entry element$iv;
            Map.Entry $dstr$id$values = element$iv = iterator2.next();
            boolean bl = false;
            EntityID id3 = (EntityID)$dstr$id$values.getKey();
            List values2 = (List)$dstr$id$values.getValue();
            SizedIterable it = sizedIterable = cache.getOrPutReferrers(id3, refColumn, (Function0)new Function0<SizedIterable<? extends T>>(values2){
                final /* synthetic */ List<T> $values;
                {
                    this.$values = $values;
                    super(0);
                }

                @NotNull
                public final SizedIterable<T> invoke() {
                    return new SizedCollection<T>((Collection)this.$values);
                }
            });
            boolean bl7 = false;
            if (!keepLoadedReferenceOutOfTransaction) continue;
            T t = this.findById(id3);
            if (t == null) continue;
            ((Entity)t).storeReferenceInCache$exposed_dao(refColumn, it);
        }
        return entities;
    }

    public static /* synthetic */ List warmUpReferences$default(EntityClass entityClass, List list2, Column column, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpReferences(list2, column, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> warmUpLinkedReferences(@NotNull List<? extends EntityID<?>> references2, @NotNull Table linkTable, @Nullable Boolean forUpdate) {
        void $this$flatMapTo$iv$iv;
        Iterable idsToLoad;
        List list2;
        List list3;
        List single$iv;
        Column sourceRefColumn;
        Iterable $this$singleOrNull$iv;
        List distinctRefIds;
        block21: {
            Column column;
            Object v0;
            block20: {
                Intrinsics.checkNotNullParameter(references2, (String)"references");
                Intrinsics.checkNotNullParameter((Object)linkTable, (String)"linkTable");
                if (references2.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                distinctRefIds = CollectionsKt.distinct((Iterable)references2);
                $this$singleOrNull$iv = linkTable.getColumns();
                boolean $i$f$singleOrNull = false;
                Object single$iv2 = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getReferee(), ((EntityID)CollectionsKt.first(references2)).getTable().getId())) continue;
                    if (found$iv) {
                        v0 = null;
                        break block20;
                    }
                    single$iv2 = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv2;
            }
            Object var7_27 = v0;
            Column column2 = column = var7_27 instanceof Column ? (Column)var7_27 : null;
            if (column == null) {
                throw new IllegalStateException("Can't detect source reference column".toString());
            }
            sourceRefColumn = column;
            Iterable $this$singleOrNull$iv2 = linkTable.getColumns();
            boolean $i$f$singleOrNull = false;
            single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv2) {
                Column it = (Column)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getReferee(), this.getTable().getId())) continue;
                if (found$iv) {
                    list3 = null;
                    break block21;
                }
                single$iv = (List)element$iv;
                found$iv = true;
            }
            list3 = !found$iv ? null : single$iv;
        }
        $this$singleOrNull$iv = list3;
        Column column = $this$singleOrNull$iv instanceof Column ? (Column)((Object)$this$singleOrNull$iv) : null;
        if (column == null) {
            throw new IllegalStateException("Can't detect target reference column".toString());
        }
        Column targetRefColumn = column;
        Transaction transaction2 = TransactionManager.Companion.current();
        Map map2 = EntityCacheKt.getEntityCache(transaction2).getReferrers$exposed_dao().get(sourceRefColumn);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map inCache = map2;
        List it = single$iv = CollectionsKt.minus((Iterable)distinctRefIds, (Iterable)inCache.keySet());
        boolean bl = false;
        List list4 = !((Collection)it).isEmpty() ? single$iv : null;
        if (list4 == null) {
            list2 = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$warmUpLinkedReferences_u24lambda_u2d48_u24lambda_u2d41;
            Object element$iv;
            idsToLoad = list4;
            boolean bl2 = false;
            element$iv = this.getDependsOnTables();
            Join join = element$iv instanceof Join ? (Join)element$iv : null;
            boolean alreadyInJoin = join == null ? false : (element$iv = join.alreadyInJoin(linkTable));
            ColumnSet entityTables = alreadyInJoin ? this.getDependsOnTables() : (ColumnSet)ColumnSet.join$default(this.getDependsOnTables(), linkTable, JoinType.INNER, targetRefColumn, this.getTable().getId(), null, 16, null);
            List columns2 = CollectionsKt.plus((Collection)CollectionsKt.distinct((Iterable)CollectionsKt.minus((Iterable)CollectionsKt.plus((Collection)this.getDependsOnColumns(), (Iterable)(!alreadyInJoin ? linkTable.getColumns() : CollectionsKt.emptyList())), (Object)sourceRefColumn)), (Object)sourceRefColumn);
            FieldSet $this$select$iv = entityTables.slice(columns2);
            boolean $i$f$select22 = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Object object = $this$select$iv;
            boolean $i$a$-select-EntityClass$warmUpLinkedReferences$loaded$2$query$22 = false;
            Query query2 = QueriesKt.select((FieldSet)object, $this$warmUpLinkedReferences_u24lambda_u2d48_u24lambda_u2d41.inList(sourceRefColumn, idsToLoad));
            Object $i$f$select22 = forUpdate;
            $i$f$select22 = Intrinsics.areEqual((Object)$i$f$select22, (Object)true) ? query2.forUpdate() : (Intrinsics.areEqual((Object)$i$f$select22, (Object)false) ? query2.notForUpdate() : query2);
            boolean $i$f$map = false;
            void $i$a$-select-EntityClass$warmUpLinkedReferences$loaded$2$query$22 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                ResultRow resultRow = (ResultRow)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(TuplesKt.to(it2.get(sourceRefColumn), this.wrapRow((ResultRow)it2)));
            }
            List entitiesWithRefs = (List)destination$iv$iv;
            Object $this$groupBy$iv = entitiesWithRefs;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Pair it3 = (Pair)element$iv$iv;
                boolean bl4 = false;
                key$iv$iv = (EntityID)it3.getFirst();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv3;
                void it4;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv2;
                boolean bl6 = false;
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map3;
                boolean bl7 = false;
                Iterable $this$map$iv2 = (Iterable)it4.getValue();
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it5;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    collection.add((Entity)it5.getSecond());
                }
                List list5 = (List)destination$iv$iv3;
                object.put(k, list5);
            }
            Map groupedBySourceId = destination$iv$iv2;
            Iterable $this$forEach$iv = idsToLoad;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                EntityID it6 = (EntityID)element$iv2;
                boolean bl9 = false;
                EntityCacheKt.getEntityCache(transaction2).getOrPutReferrers(it6, sourceRefColumn, (Function0)new Function0<SizedIterable<? extends T>>(groupedBySourceId, it6){
                    final /* synthetic */ Map<EntityID<?>, List<T>> $groupedBySourceId;
                    final /* synthetic */ EntityID<?> $it;
                    {
                        this.$groupedBySourceId = $groupedBySourceId;
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final SizedIterable<T> invoke() {
                        List<T> list2 = this.$groupedBySourceId.get(this.$it);
                        return new SizedCollection<T>(list2 == null ? (Collection)CollectionsKt.emptyList() : (Collection)list2);
                    }
                });
            }
            Iterable $this$map$iv3 = entitiesWithRefs;
            boolean $i$f$map3 = false;
            $this$mapValuesTo$iv$iv = $this$map$iv3;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it7;
                Pair list$iv$iv = (Pair)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl10 = false;
                object.add((Entity)it7.getSecond());
            }
            list2 = (List)destination$iv$iv2;
        }
        List loaded2 = list2;
        Iterable $this$flatMap$iv = inCache.values();
        boolean $i$f$flatMap = false;
        idsToLoad = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SizedIterable it8 = (SizedIterable)element$iv$iv;
            boolean bl11 = false;
            Iterable list$iv$iv = CollectionsKt.toList((Iterable)it8);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        List list6 = loaded2;
        if (list6 == null) {
            list6 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list6);
    }

    public static /* synthetic */ List warmUpLinkedReferences$default(EntityClass entityClass, List list2, Table table, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warmUpLinkedReferences");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return entityClass.warmUpLinkedReferences(list2, table, bl);
    }

    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> boolean isAssignableTo(@NotNull EntityClass<ID, ? extends T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        return entityClass.klass.isAssignableFrom(this.klass);
    }
}

